﻿WITH   RECURSIVE index_contrainte (id_objet,tableau_col,id_table,type_obj,indice_debut,id_ftable,code_obj) AS (
SELECT oid,conkey,conrelid,contype,1,confrelid,consrc FROM pg_constraint 
UNION 
SELECT indexrelid,indkey,indrelid,'i',0,NULL,CASE WHEN indisunique THEN '(Un.)' ELSE '' END||
       CASE WHEN indisclustered THEN '(Table org. index)' ELSE '' END
FROM   pg_index WHERE  indisvalid),
       eclate_colonne_obj (id_objet,tableau_col,num_col_obj,limite_nb_col_obj,position_col_obj,
                           id_table,type_obj,indice_debut,complement_objet) AS (
SELECT id_objet,tableau_col,tableau_col[indice_debut],MAX(array_length(tableau_col,1)) OVER (),1,id_table,
       CASE type_obj WHEN 'u' THEN 'UN' WHEN 'p' THEN 'PK' 
                     WHEN 'f' THEN 'FK' WHEN 'i' THEN 'IX' ELSE 'CK' END,indice_debut,
       CASE type_obj WHEN 'f' THEN '('||(SELECT relname FROM pg_class WHERE pg_class.oid=id_ftable)||')' 
                     WHEN 'c' THEN code_obj WHEN 'i' THEN code_obj ELSE '' END
FROM   index_contrainte
UNION  ALL
SELECT id_objet,tableau_col,tableau_col[position_col_obj+indice_debut],limite_nb_col_obj,
       position_col_obj+1,id_table,type_obj,indice_debut,complement_objet
FROM   eclate_colonne_obj WHERE  position_col_obj+1 <=limite_nb_col_obj),
       rang_col_obj (id_objet,id_table,num_col_obj,resultat_affiche,rang_col_obj,type_objet) AS (
SELECT id_objet,id_table,num_col_obj,type_obj||DENSE_RANK() OVER w_table_typobj||complement_objet||
       '.pos'||position_col_obj AS resultat_affiche,DENSE_RANK() OVER w_table_numcol,type_obj
FROM   eclate_colonne_obj WHERE  num_col_obj IS NOT NULL AND num_col_obj>=0
WINDOW w_table_typobj AS (PARTITION BY id_table,type_obj ORDER BY id_table,type_obj,id_objet),
       w_table_numcol AS (PARTITION BY id_table,num_col_obj ORDER BY id_table,num_col_obj,id_objet)),
       max_rang_col_obj (max_rang) AS (
SELECT MAX(rang_col_obj) FROM rang_col_obj),
       concatene_result_col(id_table,num_col_obj,resultat_affiche,num_cour) AS (
SELECT id_table,num_col_obj,resultat_affiche,1 FROM rang_col_obj WHERE  rang_col_obj=1
UNION  ALL 
SELECT concatene_result_col.id_table,concatene_result_col.num_col_obj,
       concatene_result_col.resultat_affiche||' '||rang_col_obj.resultat_affiche,concatene_result_col.num_cour+1
FROM   concatene_result_col CROSS JOIN max_rang_col_obj
JOIN   rang_col_obj ON concatene_result_col.id_table=rang_col_obj.id_table 
AND    concatene_result_col.num_col_obj=rang_col_obj.num_col_obj 
AND    concatene_result_col.num_cour+1=rang_col_obj.rang_col_obj
WHERE  num_cour<=max_rang),
       affichage_final_col_obj(id_table,num_col_obj,resultat_affiche) AS (
SELECT id_table,num_col_obj,MAX(resultat_affiche) FROM concatene_result_col GROUP BY id_table,num_col_obj)
SELECT nspname AS "Schéma",relname AS "Table",desc_tab.description AS "Desc Table",
       CASE WHEN relhasindex THEN 'Oui' ELSE NULL END AS "Idx Tab?",reltuples AS "Nb lignes",relnatts AS "Nb col.",
       attname AS "Colonne",attnum AS "No col",desc_col.description AS "Desc Col",
       pg_type.typname AS "Type col",CASE attlen WHEN -1 THEN 
       CASE atttypmod WHEN -1 THEN NULL ELSE atttypmod END ELSE attlen END AS "Lg phys. col.",
       CASE  WHEN attnotnull THEN 'Oui' ELSE NULL END AS "Oblig.?",resultat_affiche AS "Compléments (index & contraintes)"
FROM   pg_attribute JOIN pg_class ON attrelid=pg_class.oid
                    JOIN pg_namespace ON pg_class.relnamespace = pg_namespace.oid 
                    JOIN pg_type ON pg_attribute.atttypid=pg_type.oid
         LEFT OUTER JOIN pg_description desc_tab 
                      ON desc_tab.objoid=attrelid AND desc_tab.objsubid=0
         LEFT OUTER JOIN pg_description desc_col 
                      ON desc_col.objoid=attrelid AND desc_col.objsubid=attnum
         LEFT OUTER JOIN affichage_final_col_obj ON attrelid=id_table AND attnum=num_col_obj
WHERE  nspname =('public') AND attnum>=1 AND relam=0 AND NOT relistemp AND relkind='r'                                         
ORDER  BY nspname,relname,attnum;
